<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package nepalartscrafts
 */

?>
<?php 
$footBack = get_field('footer_background_image','option');
$footDesc = get_field('footer_about_description','option');
?>
<!-- =====footer section starts===== -->
<footer id="footer" style="background-image: url(<?php echo $footBack['url'] ?>);">
    <div class="footer-top sp-t sp-b">
        <div class="maincontainer">
            <div class="row">
                <div class="col-lg-4 col-sm-6 mb">
                    <div class="ft-logo">
                        <a href="<?php echo home_url(); ?>">
                            <?php the_custom_logo() ?>
                        </a>
                    </div>
                    <div class="ft-about">
                        <p><?php echo $footDesc ?></p>
                        <a href="<?php the_permalink(64) ?>">Read More</a>
                    </div>
                </div>
                <div class="col-lg-2 col-sm-6 mb">
                    <h5>Quick Links</h5>
                    <div class="ft-link">
                        <ul>
                        <?php wp_nav_menu( array( 'theme_location' => 'max_mega_menu_1' ) ); ?>
                        </ul>
                    </div>
                </div>
                <?php 
                $foocon = get_field('footer_contact_details','option');
                ?>
                <div class="col-lg-3 col-sm-6 mb">
                    <h5>Conact Us</h5>
                    <div class="ft-link contact-link">
                        <ul>
                            <?php foreach($foocon as $FooterContact){ 
                            if($foocon!=""){
                            ?>
                            <li>
                                <i class="<?php echo $FooterContact['contact_icon'] ?>"></i>
                                <a href="<?php echo $FooterContact['contact_type'] ?>"><?php echo $FooterContact['contact_detail'] ?></a>
                            </li>
                           <?php } ?>
                           <?php } ?>
                        </ul>
                    </div>
                    <?php 
                    $getin = get_field('footer_getin_touch_details','option');
                    ?>
                    <div class="social-media">
                        <h6>Get in Touch</h6>
                        <ul>
                            <?php foreach($getin as $SocialMedia){ ?>
                            <li class="<?php echo $SocialMedia['getin_name'] ?>">
                                <a href="<?php echo $SocialMedia['getin_url'] ?>" target="_blank"><i class="<?php echo $SocialMedia['getin_icon'] ?>"></i></a>
                            </li>
                           <?php } ?>
                        </ul>
                    </div>
                </div>
                <?php 
                $news = get_field('news_letter_heading','option');
                ?>
                <div class="col-lg-3 col-sm-6 mb">
                    <h5>Newsletter</h5>
                    <div class="newsletter">
                        <p><?php echo $news ?></p>
                     <?php echo do_shortcode('[contact-form-7 id="236" title="NEws LEtter"]') ?>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <div class="maincontainer">
        <div class="footer-btm">
            <div class="row">
                <div class="col-md-7 my-auto">
                    <div class="copyright text-center">
                    <p>
                    © 2023 Nepal Arts & Crafts. All Rights Reserved. Developed & Maintained by: <a href="" target="_blank">Iceberg Technology</a>
                    </p>
                    </div>
                </div>
                <div class="col-md-5 my-auto">
                    <div class="payment-accept">
                        <h6>We Accept : </h6>
						<a href="<?php echo home_url(); ?>/payment">
                        <ul>
                            <li>
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2022/12/1-1.png" alt="payment method">
                            </li>
							<li>
                                    <img src="<?php echo home_url(); ?>/wp-content/uploads/2023/08/pay.png" alt="payment method">
                                </li>
                            <li>
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2022/12/3-1.png" alt="payment method">
                            </li>
                            <li>
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2022/12/khalti.png" alt="payment method">
                            </li>
                            <li>
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2022/12/2-1.png" alt="payment method">
                            </li>
                            <li>
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2022/12/connectips.png" alt="payment method">
                            </li>
                        </ul>
						</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- =====footer section ends===== -->
<div id="scroll-top">
    <a href="#"><i class="fa-solid fa-arrow-turn-up"></i></a>
</div>
</div>
<?php wp_footer(); ?>

</body>
</html>
