<?php
/**
 * nepalartscrafts functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package nepalartscrafts
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function nepalartscrafts_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on nepalartscrafts, use a find and replace
		* to change 'nepalartscrafts' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'nepalartscrafts', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'nepalartscrafts' ),
		)
	);
	register_nav_menus(
		array(
			'menu-2' => esc_html__( 'submenu' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'nepalartscrafts_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'nepalartscrafts_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function nepalartscrafts_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'nepalartscrafts_content_width', 640 );
}
add_action( 'after_setup_theme', 'nepalartscrafts_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function nepalartscrafts_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'nepalartscrafts' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'nepalartscrafts' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'nepalartscrafts_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function nepalartscrafts_scripts() {
	wp_enqueue_style( 'nepalartscrafts-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'nepalartscrafts-style', 'rtl', 'replace' );

	//===== css starts =====
	// bootstrap css
	wp_enqueue_style('nepalartscrafts-bootstrap-css', get_template_directory_uri() .'/resources/scss/vendor/bootstrap.min.css' );
	// slick css
	wp_enqueue_style('nepalartscrafts-slick-css', get_template_directory_uri() .'/resources/scss/vendor/slick.css' );
	// lightbox css
	wp_enqueue_style('nepalartscrafts-lightbox-css', get_template_directory_uri() .'/resources/lightbox/css/lightbox.min.css' );
	// fontawesome css
	wp_enqueue_style('nepalartscrafts-fontawesome-css', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css' );
	// main css
	wp_enqueue_style('nepalartscrafts-main-css', get_template_directory_uri() .'/resources/scss/main.css' );
	// woocommerce css
	wp_enqueue_style('nepalartscrafts-woocommerce-css', get_template_directory_uri() .'/resources/scss/woo-style.css' );
	//=====css ends =====
	//=====js starts =====
	//jquery
	wp_enqueue_script('nepalartscrafts-jquery', get_template_directory_uri(). '/resources/js/vendor/jquery.min.js', array(), _S_VERSION, true);
	//bootstrap js
	wp_enqueue_script('nepalartscrafts-bootstrap-js', get_template_directory_uri(). '/resources/js/vendor/bootstrap.min.js', array(), _S_VERSION, true);
	//popper
	wp_enqueue_script('nepalartscrafts-popper', get_template_directory_uri(). '/resources/js/vendor/popper.js', array(), _S_VERSION, true);
	//slick js
	wp_enqueue_script('nepalartscrafts-slick-js', get_template_directory_uri(). '/resources/js/vendor/slick.min.js', array(), _S_VERSION, true);
	//lightbox js
	wp_enqueue_script('nepalartscrafts-lightbox-js', get_template_directory_uri(). '/resources/lightbox/js/lightbox.min.js', array(), _S_VERSION, true);
	//main js
	wp_enqueue_script('nepalartscrafts-main-js', get_template_directory_uri(). '/resources/js/custom/main.js', array(), _S_VERSION, true);
	//=====js ends=====

	wp_enqueue_script( 'nepalartscrafts-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'nepalartscrafts_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}
if( function_exists('acf_add_options_page') ) {
    
    acf_add_options_page();
    
}

//thumbnail
add_action('woocommerce_archive_description', 'woocommerce_add_category_image', 20);
function woocommerce_add_category_image()
{
    global $product;
    if (is_product_category())
    {
        global $wp_query;
        $cat = $wp_query->get_queried_object();
        $thumbnail_id = get_term_meta()($cat->term_id, 'thumbnail_id', true);
        $image = wp_get_attachment_url($thumbnail_id);
        if ($image)
        {
            echo '<img src="' . esc_url($image) . '" alt="" />';
        }
    }
   }
function WooCommerce_cart_count() {
global $woocommerce;
echo $woocommerce->cart->cart_contents_count;
}
add_action( 'woocommerce_before_cart', 'woocommerce_cart_count' );