<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package nepalartscrafts
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/12">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page">
<!-- =====section header starts===== -->
<header id="header">
	<!-- top header starts -->
	<div class="top-header">
		<div class="maincontainer">
			<div class="row">
				<div class="col-lg-6">
					<div class="logo">
						<a href="<?php echo home_url(); ?>">
						<?php the_custom_logo() ?>
						</a>
					</div>
					
				</div>
				<div class="col-lg-6 my-auto wc-col">
					<div class="wc-list">
						<ul>
							<li>
								<a href="<?php echo home_url(); ?>/my-account"><i class="fa-solid fa-user"></i> Account</a>
							</li>
							<li>
								<a href="#"><i class="fa-solid fa-heart"></i> Wishlist</a>
							</li>
							<li>
								<a href="http://icebergtechnology.com.np/nepalartscrafts/my-account/"><i class="fa-solid fa-lock"></i>Login</a>
							</li>
							<li>
								<a href="<?php echo home_url(); ?>/cart"><i class="fa-solid fa-cart-shopping"></i> <?php echo WooCommerce_cart_count() ?> <span>Item(s)</span></a>
							</li>
							<li class="search-icon" data-bs-toggle="modal" data-bs-target="#searchmodal">
								<i class="fa-solid fa-magnifying-glass"></i>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- bottom header starts -->
	<div class="btm-header">
		<div class="maincontainer">
			<div class="row">
				<div class="col-lg-3 col-md-4 col-sm-6 col-9">
					<div class="category-title">
						<i class="fa-solid fa-bars"></i><h6>Categories</h6>
					</div>
					<div class="category-list">
						<?php wp_nav_menu(array('theme_location' => 'menu-1'));	?>
					</div>
				</div>
				<div class="col-lg-9 col-md-8 col-sm-6 col-3">
					<div class="submenu-wrapper">
						<?php wp_nav_menu(array('theme_location' => 'menu-2'));	?>
					</div>
				</div>
			</div>
		</div>
	</div>
</header>

<!-- search modal popup -->
<!-- Modal -->
<div class="modal fade" id="searchmodal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title" id="exampleModalLabel">Search your Product</h1>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<form>
					<input type="text" class="form-control" placeholder="Search...">
					<input type="submit" value="search Now">
				</form>

			</div>
		</div>
	</div>
</div>
<!-- =====section header ends===== -->
